package com.posprinter.printdemo.activity

import android.content.Intent
import android.graphics.Bitmap
import android.os.Bundle
import android.provider.MediaStore
import androidx.appcompat.app.AppCompatActivity
import com.ihr810.printer.IHR810
import com.ihr810.printer.IHR810Const
import com.posprinter.printdemo.App
import com.posprinter.printdemo.R
import com.posprinter.printdemo.databinding.ActivityPosBinding
import com.posprinter.printdemo.utils.UIUtils

class PosActivity : AppCompatActivity() {
    private val printer = IHR810(App.get().curConnect)
    private lateinit var bind: ActivityPosBinding

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        bind = ActivityPosBinding.inflate(layoutInflater)
        setContentView(bind.root)
        initListener()
    }

    private fun initListener() {
        bind.btText.setOnClickListener {
            printText()
        }
        bind.btbarcode.setOnClickListener {
            printBarcode()
        }
        bind.btpic.setOnClickListener { printPIC() }
        bind.qrcode.setOnClickListener { printQRCode() }
        bind.checklink.setOnClickListener {
            val str = if (App.get().curConnect!!.isConnect) {
                "Connect"
            } else {
                "Disconnect"
            }
            UIUtils.toast(str)
        }

        bind.printerStatusBtn.setOnClickListener {
            printer.printerStatus {
                val msg = when (it) {
                    IHR810Const.STS_NORMAL -> getString(R.string.printer_normal)
                    IHR810Const.STS_COVEROPEN -> getString(R.string.printer_front_cover_open)
                    IHR810Const.STS_PAPEREMPTY -> getString(R.string.printer_out_of_paper)
                    else -> "UNKNOWN"
                }
                val str = getString(R.string.printer_status)
                UIUtils.toast("$str:${msg}")
            }
        }
    }

    private fun printText() {
        val str = bind.text.text.toString()
        printer.printString(str)
            .feedLine()
            .cutHalfAndFeed(1)
    }

    private fun printBarcode() {
        printer.initializePrinter()
            .printBarCode("B123456789", IHR810Const.BCS_Code39, 3, 162, IHR810Const.ALIGNMENT_CENTER)
            .feedLine()
            .cutHalfAndFeed(1)
    }

    private fun printQRCode() {
        val content = "Welcome to Printer Technology to create advantages Quality to win in the future"
        printer.initializePrinter()
            .printQRCode(content)
            .feedLine()
            .cutHalfAndFeed(1)
    }

    private fun printPIC() {
        val intent = Intent(Intent.ACTION_GET_CONTENT)
        intent.addCategory(Intent.CATEGORY_OPENABLE)
        intent.type = "image/*"
        startActivityForResult(intent, 0)
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == 0 && resultCode == RESULT_OK) {
            try {
                val imagePath = data!!.data
                val resolver = contentResolver
                val b = MediaStore.Images.Media.getBitmap(resolver, imagePath)
                printPicCode(b)
            } catch (e: Exception) {
                e.printStackTrace()
            }
        }
    }

    //let the printer print bitmap
    private fun printPicCode(printBmp: Bitmap) {
        printer.printBitmap(printBmp, IHR810Const.ALIGNMENT_CENTER, 340)
            .feedLine()
            .cutHalfAndFeed(1)
    }
}